package de.bebagoe.jfxcontrols;

import java.text.NumberFormat;
import java.text.ParsePosition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.*;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.layout.*;
import javafx.stage.Stage;

enum Richtung {DM2EURO, EURO2DM};

public class EuroKonverter  extends Application{
    private Label lblEingabe, lblAusgabe, lblErgebnis;
    private TextField tfEingabe;
    private Richtung richtung = Richtung.DM2EURO;
    private RadioButton euro2dm, dm2euro;

    // Konvertiert Zeichenfolge in Zahl und umgekehrt; unterstützt das lokal-übliche Zahlenformat
    private NumberFormat nf = NumberFormat.getInstance();

    @Override
    public void start(Stage stage) {
        int distGrid = 10;
        var root = new GridPane();
        root.setVgap(distGrid); root.setHgap(2* distGrid);
        root.setPadding(new Insets(distGrid, distGrid, distGrid, distGrid));

        // Dem Unicode-Zeichen \u27a0 entspricht ein horizontaler Pfeil.
        dm2euro = new RadioButton("DM "+'\u27a0'+" Euro");
        dm2euro.setSelected(true);
        dm2euro.setFocusTraversable(false);

        euro2dm = new RadioButton("Euro "+'\u27a0'+" DM");
        euro2dm.setFocusTraversable(false);

        ToggleGroup rbGroup = new ToggleGroup();
        rbGroup.getToggles().addAll(euro2dm, dm2euro);

        rbGroup.selectedToggleProperty().addListener(this::rbChanged);

        var cbBeenden = new Button("Ende");
        cbBeenden.setFocusTraversable(false);
        cbBeenden.setOnAction(event ->  Platform.exit());

        tfEingabe = new TextField("");

        tfEingabe.setAlignment(Pos.BASELINE_RIGHT);
        lblEingabe = new Label("DM");

        lblErgebnis = new Label();
        lblErgebnis.setStyle("-fx-border-color: lightblue");
        int distErg = 5;
        lblErgebnis.setPadding(new Insets(distErg, distErg, distErg, distErg));
        lblErgebnis.setAlignment(Pos.BASELINE_RIGHT);
		var anchorPane = new AnchorPane();
		AnchorPane.setLeftAnchor(lblErgebnis, 0.0);
		AnchorPane.setRightAnchor(lblErgebnis, 0.0);
		anchorPane.getChildren().add(lblErgebnis);

        lblAusgabe = new Label("Euro");

        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);

        var cbKonvertieren = new Button("Konvertieren");
        cbKonvertieren.setOnAction(event -> {
            ParsePosition pp = new ParsePosition(0);
            String eingabe = tfEingabe.getText();
            String ausgabe;
            if (eingabe.length() == 0) {
                tfEingabe.requestFocus();
                return;
            }
            double factor = 1.95583;
            if (richtung == Richtung.EURO2DM) {
                factor = 1.95583;
            }
            else {
                factor = 1.0/1.95583;
            }
            try {
                // parse() akzeptiert z.B. auch "1komma3".
                // Mit Hilfe des ParsePosition-Objekts wird erkannt, wenn die Interpretation vor dem Ende der Zeichenfolge stoppt.
                pp.setIndex(0);
                Number n = nf.parse(eingabe, pp);
                if (pp.getIndex() != eingabe.length())
                    throw new NumberFormatException("Die numerische Interpretation der Eingabe wurde abgebrochen");
                double wert = n.doubleValue();
                wert *= factor;
                ausgabe = nf.format(wert);
                lblErgebnis.setText(ausgabe);
            } catch (final Exception ex) {
                Alert alert = new Alert(AlertType.ERROR, ex.getMessage());
                alert.setHeaderText("Fehler");
                alert.showAndWait();
            }
            tfEingabe.requestFocus();
            tfEingabe.selectAll();
        });

        cbKonvertieren.setDefaultButton(true);

        root.add(dm2euro, 0, 0);
        root.add(euro2dm, 0, 1);
        root.add(cbBeenden, 0, 2);

        root.add(tfEingabe, 1, 0);
//		root.add(lblErgebnis, 1, 1);
        root.add(anchorPane, 1, 1);
        root.add(cbKonvertieren, 1, 2);

        root.add(lblEingabe, 2, 0);
        root.add(lblAusgabe, 2, 1);

        Scene scene = new Scene(root, 320, 120);
        tfEingabe.requestFocus();
        stage.setScene(scene);
        stage.setTitle("DM-Euro - Konverter");
        stage.setResizable(false);
        stage.show();
    }

    private void rbChanged(ObservableValue<? extends Toggle> obs, Toggle old, Toggle nev) {
        tfEingabe.setText("");
		lblErgebnis.setText("");
        if (nev == euro2dm) {
            lblEingabe.setText("Euro");
            lblAusgabe.setText("DM");
            richtung = Richtung.EURO2DM;
        } else {
            lblEingabe.setText("DM");
            lblAusgabe.setText("Euro");
            richtung = Richtung.DM2EURO;
        }
    }

    public static void main(String[] args) {
        launch(args);
    }
}
